"use client"

import { Card, CardContent, CardHeader, CardTitle, CardDescription } from "@/components/ui/card"
import { Button } from "@/components/ui/button"
import { Switch } from "@/components/ui/switch"
import { Bell, Mail, Smartphone, MessageSquare, Calendar, Wallet, Save } from "lucide-react"

export function NotificationSettings() {
  return (
    <div className="space-y-6">
      {/* Email Notifications */}
      <Card className="border bg-card">
        <CardHeader>
          <div className="flex items-center gap-3">
            <div className="p-2 rounded-lg bg-blue-500">
              <Mail className="h-5 w-5 text-white" />
            </div>
            <div>
              <CardTitle>Email Notifications</CardTitle>
              <CardDescription>Manage what emails you receive</CardDescription>
            </div>
          </div>
        </CardHeader>
        <CardContent className="space-y-3">
          <div className="flex items-center justify-between p-4 rounded-xl bg-muted/30 border border-border/50">
            <div className="flex items-center gap-3">
              <Calendar className="h-4 w-4 text-muted-foreground" />
              <div>
                <p className="font-medium">New Bookings</p>
                <p className="text-sm text-muted-foreground">Get notified when you receive a new booking</p>
              </div>
            </div>
            <Switch defaultChecked />
          </div>

          <div className="flex items-center justify-between p-4 rounded-xl bg-muted/30 border border-border/50">
            <div className="flex items-center gap-3">
              <MessageSquare className="h-4 w-4 text-muted-foreground" />
              <div>
                <p className="font-medium">Guest Messages</p>
                <p className="text-sm text-muted-foreground">Receive email when guests send messages</p>
              </div>
            </div>
            <Switch defaultChecked />
          </div>

          <div className="flex items-center justify-between p-4 rounded-xl bg-muted/30 border border-border/50">
            <div className="flex items-center gap-3">
              <Wallet className="h-4 w-4 text-muted-foreground" />
              <div>
                <p className="font-medium">Payment Updates</p>
                <p className="text-sm text-muted-foreground">Get notified about payment and withdrawal status</p>
              </div>
            </div>
            <Switch defaultChecked />
          </div>

          <div className="flex items-center justify-between p-4 rounded-xl bg-muted/30 border border-border/50">
            <div className="flex items-center gap-3">
              <Bell className="h-4 w-4 text-muted-foreground" />
              <div>
                <p className="font-medium">Weekly Summary</p>
                <p className="text-sm text-muted-foreground">Receive weekly performance reports</p>
              </div>
            </div>
            <Switch />
          </div>
        </CardContent>
      </Card>

      {/* Push Notifications */}
      <Card className="border bg-card">
        <CardHeader>
          <div className="flex items-center gap-3">
            <div className="p-2 rounded-lg bg-emerald-500">
              <Smartphone className="h-5 w-5 text-white" />
            </div>
            <div>
              <CardTitle>Push Notifications</CardTitle>
              <CardDescription>Manage mobile and browser notifications</CardDescription>
            </div>
          </div>
        </CardHeader>
        <CardContent className="space-y-3">
          <div className="flex items-center justify-between p-4 rounded-xl bg-muted/30 border border-border/50">
            <div>
              <p className="font-medium">Browser Notifications</p>
              <p className="text-sm text-muted-foreground">Show desktop notifications</p>
            </div>
            <Switch defaultChecked />
          </div>

          <div className="flex items-center justify-between p-4 rounded-xl bg-muted/30 border border-border/50">
            <div>
              <p className="font-medium">Mobile Push</p>
              <p className="text-sm text-muted-foreground">Send notifications to mobile app</p>
            </div>
            <Switch defaultChecked />
          </div>

          <div className="flex items-center justify-between p-4 rounded-xl bg-muted/30 border border-border/50">
            <div>
              <p className="font-medium">Urgent Alerts Only</p>
              <p className="text-sm text-muted-foreground">Only receive critical notifications</p>
            </div>
            <Switch />
          </div>
        </CardContent>
      </Card>

      {/* SMS Notifications */}
      <Card className="border bg-card">
        <CardHeader>
          <div className="flex items-center gap-3">
            <div className="p-2 rounded-lg bg-violet-500">
              <MessageSquare className="h-5 w-5 text-white" />
            </div>
            <div>
              <CardTitle>SMS Notifications</CardTitle>
              <CardDescription>Receive important updates via SMS</CardDescription>
            </div>
          </div>
        </CardHeader>
        <CardContent className="space-y-3">
          <div className="flex items-center justify-between p-4 rounded-xl bg-muted/30 border border-border/50">
            <div>
              <p className="font-medium">Booking Confirmations</p>
              <p className="text-sm text-muted-foreground">SMS for new confirmed bookings</p>
            </div>
            <Switch defaultChecked />
          </div>

          <div className="flex items-center justify-between p-4 rounded-xl bg-muted/30 border border-border/50">
            <div>
              <p className="font-medium">Check-in Reminders</p>
              <p className="text-sm text-muted-foreground">Remind about upcoming guest arrivals</p>
            </div>
            <Switch />
          </div>

          <div className="flex items-center justify-between p-4 rounded-xl bg-muted/30 border border-border/50">
            <div>
              <p className="font-medium">Withdrawal Status</p>
              <p className="text-sm text-muted-foreground">Updates on withdrawal processing</p>
            </div>
            <Switch defaultChecked />
          </div>
        </CardContent>
      </Card>

      <div className="flex justify-end gap-3">
        <Button variant="outline">Reset to Default</Button>
        <Button className="bg-slate-900 hover:bg-slate-800 dark:bg-white dark:text-slate-900 dark:hover:bg-slate-100">
          <Save className="h-4 w-4 mr-2" />
          Save Preferences
        </Button>
      </div>
    </div>
  )
}
