import { Skeleton } from "@/components/ui/skeleton"

export default function SpiritualBookingLoading() {
  return (
    <div className="min-h-screen bg-gradient-to-br from-gray-50 via-white to-gray-100 p-6">
      <Skeleton className="h-32 w-full rounded-2xl mb-8" />
      <div className="flex gap-6">
        <Skeleton className="h-12 w-48" />
        <Skeleton className="h-12 flex-1 rounded-xl" />
      </div>
      <div className="mt-6 space-y-4">
        {[...Array(4)].map((_, i) => (
          <Skeleton key={i} className="h-24 rounded-xl" />
        ))}
      </div>
    </div>
  )
}
