import type { Metadata } from "next"
import { Suspense } from "react"
import { Skeleton } from "@/components/ui/skeleton"
import { VehicleBookingsClient } from "@/components/admin/vehicle-bookings/vehicle-bookings-client"

export const metadata: Metadata = {
  title: "Vehicle Bookings | Teertham Admin",
  description:
    "Manage all vehicle bookings on Teertham platform. View booked, ongoing, completed and cancelled vehicle reservations.",
  robots: { index: false, follow: false },
  openGraph: {
    title: "Vehicle Bookings | Teertham Admin",
    description: "Manage all vehicle bookings on Teertham platform.",
    type: "website",
  },
}

// Loading skeleton component
function VehicleBookingsLoading() {
  return (
    <div className="space-y-6">
      <div>
        <Skeleton className="h-8 w-48" />
        <Skeleton className="h-4 w-72 mt-2" />
      </div>
      <div className="grid gap-4 sm:grid-cols-2 lg:grid-cols-5">
        {[...Array(5)].map((_, i) => (
          <Skeleton key={i} className="h-28 rounded-xl" />
        ))}
      </div>
      <Skeleton className="h-12 w-full rounded-xl" />
      <Skeleton className="h-96 w-full rounded-xl" />
    </div>
  )
}

export default function VehicleBookingsPage() {
  return (
    <main>
      <Suspense fallback={<VehicleBookingsLoading />}>
        <VehicleBookingsClient />
      </Suspense>
    </main>
  )
}
