import type { Metadata } from "next"
import { SpiritualPackagesClient } from "@/components/admin/spiritual-packages/spiritual-packages-client"

export const metadata: Metadata = {
  title: "Spiritual Packages | Teertham Admin",
  description: "Manage spiritual packages on Teertham platform",
  openGraph: {
    title: "Spiritual Packages | Teertham Admin",
    description: "Manage spiritual packages on Teertham platform",
  },
  twitter: {
    card: "summary",
    title: "Spiritual Packages | Teertham Admin",
    description: "Manage spiritual packages on Teertham platform",
  },
}

export default function SpiritualPackagesPage() {
  return (
    <section aria-labelledby="spiritual-packages-heading" className="admin-section">
      <header className="admin-page-header">
        <div>
          <h1 id="spiritual-packages-heading" className="admin-page-title">
            Spiritual Packages
          </h1>
          <p className="admin-page-description">View and manage all spiritual packages</p>
        </div>
      </header>

      <SpiritualPackagesClient />
    </section>
  )
}
